<?php
// process.php - Smart High Quality Compression
header('Content-Type: application/json');
ini_set('memory_limit', '256M'); // बडी फाइल के लिए मेमोरी बढ़ाएं

$response = ['success' => false, 'message' => ''];
$uploadDir = 'uploads/';

if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['image'])) {
    
    $file = $_FILES['image'];
    $targetKB = isset($_POST['target_kb']) && $_POST['target_kb'] != '' ? intval($_POST['target_kb']) : 0;
    
    // यूजर ने अगर मैन्युअल width/height दी है
    $userWidth = isset($_POST['width']) && $_POST['width'] != '' ? intval($_POST['width']) : 0;
    $userHeight = isset($_POST['height']) && $_POST['height'] != '' ? intval($_POST['height']) : 0;
    
    $rotate = isset($_POST['rotate']) ? intval($_POST['rotate']) : 0;
    $format = isset($_POST['format']) ? $_POST['format'] : 'original';

    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $originalPath = $uploadDir . 'temp_' . time() . '.' . $ext;
    
    if (move_uploaded_file($file['tmp_name'], $originalPath)) {
        
        // इमेज लोड करें
        if ($ext == 'jpg' || $ext == 'jpeg') $image = imagecreatefromjpeg($originalPath);
        elseif ($ext == 'png') $image = imagecreatefrompng($originalPath);
        elseif ($ext == 'webp') $image = imagecreatefromwebp($originalPath);
        else {
            echo json_encode(['success' => false, 'message' => 'Unsupported format']);
            exit;
        }

        // 1. ROTATE (सीधा करें)
        if ($rotate != 0) {
            $image = imagerotate($image, -$rotate, 0);
        }

        // 2. INITIAL DIMENSIONS
        $origW = imagesx($image);
        $origH = imagesy($image);
        
        // अगर यूजर ने मैन्युअल साइज नहीं दिया, तो हम बड़ी फाइलों को पहले ही छोटा कर लेंगे
        // ताकि क्वालिटी ख़राब न हो। (CSP के लिए 1200px काफी होता है)
        if ($userWidth == 0 && $userHeight == 0) {
            if ($targetKB > 0 && $targetKB <= 50 && $origW > 1000) {
                // अगर 50KB से कम चाहिए और फोटो बहुत बड़ी है, तो उसे छोटा करो
                $newWidth = 800; 
                $newHeight = floor($origH * ($newWidth / $origW));
            } elseif ($targetKB > 0 && $targetKB <= 100 && $origW > 1500) {
                 $newWidth = 1200; 
                 $newHeight = floor($origH * ($newWidth / $origW));
            } else {
                $newWidth = $origW;
                $newHeight = $origH;
            }
        } else {
            // यूजर द्वारा दिया गया साइज
            if ($userWidth > 0 && $userHeight > 0) {
                $newWidth = $userWidth;
                $newHeight = $userHeight;
            } elseif ($userWidth > 0) {
                $newWidth = $userWidth;
                $newHeight = floor($origH * ($userWidth / $origW));
            } elseif ($userHeight > 0) {
                $newWidth = floor($origW * ($userHeight / $origH));
                $newHeight = $userHeight;
            } else {
                $newWidth = $origW;
                $newHeight = $origH;
            }
        }

        // फाइनल फॉर्मेट तय करें
        $outExt = ($format == 'original') ? $ext : $format;
        if($outExt == 'jpg') $outExt = 'jpeg';

        $finalName = 'processed_' . time() . '.' . $outExt;
        $finalPath = $uploadDir . $finalName;

        // --- SMART COMPRESSION LOGIC ---
        
        // एक लूप चलाएंगे जो साइज चेक करेगा
        // पहले हम क्वालिटी कम करेंगे (90 -> 70 तक)
        // अगर फिर भी साइज ज्यादा है, तो हम Resolution (width) कम करेंगे, क्वालिटी नहीं गिराएंगे
        
        $currentQuality = 90;
        $minQuality = 60; // 60 से नीचे क्वालिटी नहीं जाने देंगे (ताकि धुंधला न हो)
        $loopWidth = $newWidth;
        $loopHeight = $newHeight;
        $attempts = 0;
        $maxAttempts = 10; // सर्वर हैंग न हो इसलिए लिमिट
        $finished = false;

        do {
            // हर बार नई खाली इमेज बनाएं (ताकि रिसाइजिंग साफ़ हो)
            $tempImg = imagecreatetruecolor($loopWidth, $loopHeight);
            
            // पारदर्शिता (Transparency) संभालें
            if ($outExt == 'png' || $outExt == 'webp') {
                imagealphablending($tempImg, false);
                imagesavealpha($tempImg, true);
            } else {
                // JPG के लिए वाइट बैकग्राउंड
                $white = imagecolorallocate($tempImg, 255, 255, 255);
                imagefill($tempImg, 0, 0, $white);
            }

            // रिसाइज करें (High Quality Resampling)
            imagecopyresampled($tempImg, $image, 0, 0, 0, 0, $loopWidth, $loopHeight, $origW, $origH);

            // फाइल सेव करें
            if ($outExt == 'png') {
                // PNG में क्वालिटी ज्यादा कण्ट्रोल नहीं होती (0-9)
                imagepng($tempImg, $finalPath, 6); 
            } elseif ($outExt == 'webp') {
                imagewebp($tempImg, $finalPath, $currentQuality);
            } else {
                imagejpeg($tempImg, $finalPath, $currentQuality);
            }
            
            imagedestroy($tempImg);
            clearstatcache();
            
            $fileSize = filesize($finalPath);
            $currentKB = $fileSize / 1024;

            // अगर Target KB सेट नहीं है, तो बस एक बार सेव करके बाहर आ जाएं
            if ($targetKB == 0) {
                $finished = true;
                break;
            }

            // चेक करें क्या साइज कम हुआ?
            if ($currentKB <= $targetKB) {
                $finished = true;
            } else {
                // साइज अभी भी ज्यादा है
                $attempts++;
                
                if ($currentQuality > 70) {
                    // पहले थोड़ी क्वालिटी कम करो
                    $currentQuality -= 10;
                } else {
                    // अगर क्वालिटी 70 पर आ गयी, फिर भी साइज ज्यादा है
                    // तो अब QUALITY मत गिराओ, PHOTO छोटी करो (Smart Move)
                    $loopWidth = floor($loopWidth * 0.9); // 10% छोटा करो
                    $loopHeight = floor($loopHeight * 0.9);
                }

                // बहुत ज्यादा छोटा न होने दें
                if ($loopWidth < 300 || $attempts >= $maxAttempts) {
                    $finished = true; // अब जो है वही दे दो
                }
            }

        } while (!$finished);

        // Cleanup
        imagedestroy($image);
        unlink($originalPath);

        $response['success'] = true;
        $response['url'] = $finalPath;
        $response['filename'] = $finalName;
        $response['size'] = round(filesize($finalPath) / 1024, 2) . ' KB';

    } else {
        $response['message'] = 'Server Upload Error';
    }
}

echo json_encode($response);
?>